/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.BulletWeapon;
import immersive_aircraft.network.c2s.FireMessage;
import net.minecraft.class_1297;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class HeavyCrossbow
extends BulletWeapon {
    private static final float MAX_COOLDOWN = 1.0f;
    private float cooldown = 0.0f;
    private final float velocity;
    private final float inaccuracy;

    public HeavyCrossbow(VehicleEntity entity, class_1799 stack, WeaponMount mount, int slot) {
        this(entity, stack, mount, slot, Config.getInstance().heavyCrossBowVelocity, 0.0f);
    }

    public HeavyCrossbow(VehicleEntity entity, class_1799 stack, WeaponMount mount, int slot, float velocity, float inaccuracy) {
        super(entity, stack, mount, slot);
        this.velocity = velocity;
        this.inaccuracy = inaccuracy;
    }

    @Override
    protected float getBarrelLength() {
        return 1.25f;
    }

    @Override
    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, 0.3f, 0.0f, 1.0f);
    }

    public float getVelocity() {
        return this.velocity;
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    @Override
    protected class_1297 getBullet(class_1297 shooter, Vector4f position, Vector3f direction) {
        class_1667 arrow = new class_1667(shooter.method_37908(), (double)position.x(), (double)position.y(), (double)position.z());
        arrow.field_7572 = class_1665.class_1666.field_7592;
        arrow.method_7432((class_1297)this.getEntity().method_5642());
        arrow.method_7485((double)direction.x(), (double)(direction.y() + 0.1f), (double)direction.z(), this.getVelocity(), this.getInaccuracy());
        class_1799 ammoStack = this.getAmmoStack();
        if (ammoStack != null) {
            arrow.method_7459(ammoStack);
        }
        return arrow;
    }

    @Override
    public void tick() {
        this.cooldown -= 0.05f;
    }

    @Override
    public void fire(Vector3f direction) {
        if (this.spentAmmo(Config.getInstance().arrowAmmunition, 50)) {
            super.fire(direction);
        }
    }

    @Override
    public void clientFire(int index) {
        if (this.cooldown <= 0.0f) {
            this.cooldown = 1.0f;
            NetworkHandler.sendToServer(new FireMessage(this.getSlot(), index, this.getDirection()));
        }
    }

    private Vector3f getDirection() {
        Vector3f direction = new Vector3f(0.0f, 0.0f, 1.0f);
        direction.mul((Matrix3fc)new Matrix3f((Matrix4fc)this.getMount().transform()));
        direction.mul((Matrix3fc)this.getEntity().getVehicleNormalTransform());
        return direction;
    }

    public float getCooldown() {
        return Math.max(0.0f, this.cooldown / 1.0f);
    }
}

